### FedRep

FedRep learns a shared data representation (the global layers) across clients and a unique, personalized local "head" (the local layers) for each client. In this implementation, after each round of local training, only the representation on each client is retrieved and uploaded to the server for aggregation.

```bash
cd examples/personalized_fl/fedrep
uv run fedrep.py -c ../configs/fedrep_CIFAR10_resnet18.yml
```

**Reference:** Collins et al., "[Exploiting Shared Representations for Personalized Federated Learning](http://proceedings.mlr.press/v139/collins21a/collins21a.pdf)," in Proc. International Conference on Machine Learning (ICML), 2021.

---

### FedBABU

FedBABU only updates the global layers of the model during FL training. The local layers are frozen at the beginning of each local training epoch.

```bash
cd examples/personalized_fl/fedbabu
uv run fedbabu.py -c ../configs/fedbabu_CIFAR10_resnet18.yml
```

**Reference:** Oh et al., "[FedBABU: Towards Enhanced Representation for Federated Image Classification](https://openreview.net/forum?id=HuaYQfggn5u)," in Proc. International Conference on Learning Representations (ICLR), 2022.

---

### APFL

APFL jointly optimizes the global model and personalized models by interpolating between local and personalized models. Once the global model is received, each client will carry out a regular local update, and then conduct a personalized optimization to acquire a trained personalized model. The trained global model and the personalized model will subsequently be combined using the parameter "alpha," which can be dynamically updated.

```bash
cd examples/personalized_fl/apfl
uv run apfl.py -c ../configs/apfl_CIFAR10_resnet18.yml
```

**Reference:** Deng et al., "[Adaptive Personalized Federated Learning](https://arxiv.org/abs/2003.13461)," in Arxiv, 2021.

---

### FedPer

FedPer learns a global representation and personalized heads, but makes simultaneous local updates for both sets of parameters, therefore makes the same number of local updates for the head and the representation on each local round.

```bash
cd examples/personalized_fl/fedper
uv run fedper.py -c ../configs/fedper_CIFAR10_resnet18.yml
```

**Reference:** Arivazhagan et al., "[Federated learning with personalization layers](https://arxiv.org/abs/1912.00818)," in Arxiv, 2019.

---

### LG-FedAvg

With LG-FedAvg only the global layers of a model are sent to the server for aggregation, while each client keeps local layers to itself.

```bash
cd examples/personalized_fl/lgfedavg
uv run lgfedavg.py -c ../configs/lgfedavg_CIFAR10_resnet18.yml
```

**Reference:** Liang et al., "[Think Locally, Act Globally: Federated Learning with Local and Global Representations](https://arxiv.org/abs/2001.01523)," in Proc. NeurIPS, 2019.

---

### Ditto

Ditto jointly optimizes the global model and personalized models by learning local models that are encouraged to be close together by global regularization. In this example, once the global model is received, each client will carry out a regular local update and then optimizes the personalized model.

```bash
cd examples/personalized_fl/ditto
uv run ditto.py -c ../configs/ditto_CIFAR10_resnet18.yml
```

**Reference:** Li et al., "[Ditto: Fair and robust federated learning through personalization](https://proceedings.mlr.press/v139/li21h.html)," in Proc ICML, 2021.

---

### Per-FedAvg

Per-FedAvg uses the Model-Agnostic Meta-Learning (MAML) framework to perform local training during the regular training rounds. It performs two forward and backward passes with fixed learning rates in each iteration.

```bash
cd examples/personalized_fl/perfedavg
uv run perfedavg.py -c ../configs/perfedavg_CIFAR10_resnet18.yml
```

**Reference:** Fallah et al., "[Personalized Federated Learning with Theoretical Guarantees: A Model-Agnostic Meta-Learning Approach](https://proceedings.neurips.cc/paper/2020/hash/24389bfe4fe2eba8bf9aa9203a44cdad-Abstract.html)," in Proc NeurIPS, 2020.

---

### Hermes

Hermes utilizes structured pruning to improve both communication efficiency and inference efficiency of federated learning. It prunes channels with the lowest magnitudes in each local model and adjusts the pruning amount based on each local model's test accuracy and its previous pruning amount. When the server aggregates pruned updates, it only averages parameters that were not pruned on all clients.

```bash
cd examples/personalized_fl/hermes
uv run hermes.py -c ../configs/hermes_CIFAR10_resnet18.yml
```

**Reference:** Li et al., "[Hermes: An Efficient Federated Learning Framework for Heterogeneous Mobile Clients](https://sites.duke.edu/angli/files/2021/10/2021_Mobicom_Hermes_v1.pdf)," in Proc. 27th Annual International Conference on Mobile Computing and Networking (MobiCom), 2021.
